/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.machine.model;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.tools.XML;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.BuildVolume;
import replicatorg.machine.model.ClampModel;
import replicatorg.machine.model.Endstops;
import replicatorg.machine.model.ToolModel;
import replicatorg.util.Point5d;

public class MachineModel {
    protected Node xml = null;
    private Point5d minimum;
    private Point5d maximum;
    private EnumMap<AxisId, Endstops> endstops = new EnumMap(AxisId.class);
    private Set<AxisId> axes = EnumSet.noneOf(AxisId.class);
    private Point5d maximumFeedrates;
    private Point5d homingFeedrates;
    private Point5d stepsPerMM;
    protected boolean drivesEnabled = true;
    protected int gearRatio = 0;
    protected Vector<ToolModel> tools;
    protected final AtomicReference<ToolModel> currentTool = new AtomicReference();
    protected final ToolModel nullTool = new ToolModel();
    protected Vector<ClampModel> clamps = new Vector();
    protected BuildVolume buildVolume;

    public MachineModel() {
        this.tools = new Vector();
        this.buildVolume = new BuildVolume(100, 100, 100);
        this.minimum = new Point5d();
        this.maximum = new Point5d();
        this.maximumFeedrates = new Point5d();
        this.homingFeedrates = new Point5d();
        this.stepsPerMM = new Point5d(1.0, 1.0, 1.0, 1.0, 1.0);
        this.currentTool.set(this.nullTool);
    }

    public void loadXML(Node node) {
        this.xml = node;
        this.parseAxes();
        this.parseClamps();
        this.parseTools();
        this.parseBuildVolume();
    }

    private void parseAxes() {
        if (XML.hasChildNode(this.xml, "geometry")) {
            Node geometry = XML.getChildNodeByName(this.xml, "geometry");
            NodeList axisNodes = geometry.getChildNodes();
            int i = 0;
            while (i < axisNodes.getLength()) {
                Node axis = axisNodes.item(i);
                if (axis.getNodeName().equals("axis")) {
                    String idStr = XML.getAttributeValue(axis, "id");
                    try {
                        AxisId id = AxisId.valueOf(idStr.toUpperCase());
                        this.axes.add(id);
                        double length = 0.0;
                        double maxFeedrate = 0.0;
                        double homingFeedrate = 0.0;
                        double stepspermm = 1.0;
                        Endstops endstops = Endstops.NONE;
                        try {
                            length = Double.parseDouble(XML.getAttributeValue(axis, "length"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            maxFeedrate = Double.parseDouble(XML.getAttributeValue(axis, "maxfeedrate"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            homingFeedrate = Double.parseDouble(XML.getAttributeValue(axis, "homingfeedrate"));
                        }
                        catch (Exception e) {
                            homingFeedrate = maxFeedrate;
                        }
                        try {
                            String spmm = XML.getAttributeValue(axis, "stepspermm");
                            if (spmm == null) {
                                spmm = XML.getAttributeValue(axis, "scale");
                            }
                            stepspermm = Double.parseDouble(spmm);
                        }
                        catch (Exception spmm) {
                            // empty catch block
                        }
                        String endstopStr = XML.getAttributeValue(axis, "endstops");
                        if (endstopStr != null) {
                            try {
                                endstops = Endstops.valueOf(endstopStr.toUpperCase());
                            }
                            catch (IllegalArgumentException iae) {
                                Base.logger.severe("Unrecognized endstop value " + endstopStr + " for axis " + id.name());
                            }
                        }
                        this.maximum.setAxis(id, length);
                        this.maximumFeedrates.setAxis(id, maxFeedrate);
                        this.homingFeedrates.setAxis(id, homingFeedrate);
                        this.stepsPerMM.setAxis(id, stepspermm);
                        this.endstops.put(id, endstops);
                        Base.logger.fine("Loaded axis " + id.name() + ": (Length: " + length + "mm, max feedrate: " + maxFeedrate + " mm/min, homing feedrate: " + homingFeedrate + " mm/min, scale: " + stepspermm + " steps/mm)");
                    }
                    catch (IllegalArgumentException iae) {
                        Base.logger.severe("Unrecognized axis " + idStr + " found in machine descriptor!");
                    }
                }
                ++i;
            }
        }
    }

    private void parseClamps() {
        if (XML.hasChildNode(this.xml, "clamps")) {
            Node clampsNode = XML.getChildNodeByName(this.xml, "clamps");
            NodeList clampKids = clampsNode.getChildNodes();
            int i = 0;
            while (i < clampKids.getLength()) {
                Node clampNode = clampKids.item(i);
                ClampModel clamp = new ClampModel(clampNode);
                this.clamps.add(clamp);
                System.out.println("adding clamp #" + this.clamps.size());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTools() {
        if (XML.hasChildNode(this.xml, "tools")) {
            Node toolsNode = XML.getChildNodeByName(this.xml, "tools");
            NodeList toolKids = toolsNode.getChildNodes();
            int i = 0;
            while (i < toolKids.getLength()) {
                Node toolNode = toolKids.item(i);
                if (toolNode.getNodeName().equals("tool")) {
                    ToolModel tool = new ToolModel(toolNode);
                    if (tool.getIndex() == -1) {
                        tool.setIndex(this.tools.size());
                        this.tools.add(tool);
                    } else {
                        if (this.tools.size() <= tool.getIndex()) {
                            this.tools.setSize(tool.getIndex() + 1);
                        }
                        this.tools.set(tool.getIndex(), tool);
                    }
                    AtomicReference<ToolModel> atomicReference = this.currentTool;
                    synchronized (atomicReference) {
                        if (this.currentTool.get() == this.nullTool) {
                            this.selectTool(tool.getIndex());
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void parseBuildVolume() {
        if (XML.hasChildNode(this.xml, "geometry")) {
            Node geometry = XML.getChildNodeByName(this.xml, "geometry");
            NodeList axes = geometry.getChildNodes();
            int i = 0;
            while (i < axes.getLength()) {
                Node axis = axes.item(i);
                if (axis.getNodeName().equals("axis")) {
                    String id = XML.getAttributeValue(axis, "id");
                    double length = 100.0;
                    try {
                        length = Double.parseDouble(XML.getAttributeValue(axis, "length"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (id.toLowerCase().equals("x")) {
                        this.buildVolume.setX((int)length);
                    } else if (id.toLowerCase().equals("y")) {
                        this.buildVolume.setY((int)length);
                    } else if (id.toLowerCase().equals("z")) {
                        this.buildVolume.setZ((int)length);
                    }
                }
                ++i;
            }
        }
    }

    public Set<AxisId> getAvailableAxes() {
        return this.axes;
    }

    public boolean hasAxis(AxisId id) {
        return this.axes.contains((Object)id);
    }

    public Point5d stepsToMM(Point5d steps) {
        Point5d temp = new Point5d();
        temp.div(steps, this.stepsPerMM);
        return temp;
    }

    public Point5d getStepsPerMM() {
        return this.stepsPerMM;
    }

    public Point5d mmToSteps(Point5d mm) {
        Point5d temp = new Point5d();
        temp.mul(mm, this.stepsPerMM);
        temp.round();
        return temp;
    }

    public Point5d mmToSteps(Point5d mm, Point5d excess) {
        Point5d temp = new Point5d();
        temp.mul(mm, this.stepsPerMM);
        temp.add(excess);
        temp.round(excess);
        return temp;
    }

    public void enableDrives() {
        this.drivesEnabled = true;
    }

    public void disableDrives() {
        this.drivesEnabled = false;
    }

    public boolean areDrivesEnabled() {
        return this.drivesEnabled;
    }

    public void changeGearRatio(int ratioIndex) {
        this.gearRatio = ratioIndex;
    }

    public ClampModel getClamp(int index) {
        try {
            ClampModel c = this.clamps.get(index);
            return c;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot get non-existant clamp (#" + index + ".");
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTool(int index) {
        AtomicReference<ToolModel> atomicReference = this.currentTool;
        synchronized (atomicReference) {
            try {
                this.currentTool.set(this.tools.get(index));
                if (this.currentTool.get() == null) {
                    Base.logger.severe("Cannot select non-existant tool (#" + index + ").");
                    this.currentTool.set(this.nullTool);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.xml != null) {
                    Base.logger.severe("Cannot select non-existant tool (#" + index + ").");
                }
                this.currentTool.set(this.nullTool);
            }
        }
    }

    public ToolModel currentTool() {
        return this.currentTool.get();
    }

    public ToolModel getTool(int index) {
        try {
            return this.tools.get(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot get non-existant tool (#" + index + ".");
            e.printStackTrace();
            return null;
        }
    }

    public BuildVolume getBuildVolume() {
        return this.buildVolume;
    }

    public Vector<ToolModel> getTools() {
        return this.tools;
    }

    public void addTool(ToolModel t) {
        this.tools.add(t);
    }

    public void setTool(int index, ToolModel t) {
        try {
            this.tools.set(index, t);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Base.logger.severe("Cannot set non-existant tool (#" + index + ".");
            e.printStackTrace();
        }
    }

    public Point5d getMaximumFeedrates() {
        return this.maximumFeedrates;
    }

    public Point5d getHomingFeedrates() {
        return this.homingFeedrates;
    }

    public Endstops getEndstops(AxisId axis) {
        return this.endstops.get((Object)axis);
    }
}

